unit MySys;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, fileutil;

type
  TFileInString = class (TObject)
    //       . +   .
    FileString : ANSIString;
    Siz : int64;
    FirstLoaded : boolean;
    Constructor Init;
    procedure Load(const FName : string);
    Procedure Save(const FName : string);
    Procedure MakNewFile;
    Procedure AddChar(const ch : char);
    Procedure AddByte(const bt : byte);
  end;
  ChetireBaita = array[1..4] of byte;
  StoIntegerov = array[1..100] of integer;
  
Function GetFilePath(FileName : string) : string;
Function GetFileName(const FileName : string) : string;
Function GenerateNumName(const Sch : int64; nam : string) : string;
Function ByteToIntStr(const buf : byte) : string;
Function Chetnoe(const Int : int64) : boolean;
Function FileExists(const FName, Dir : string) : boolean;
Function WstateToInt(Const WState : TWindowState) : Integer;
Function IntToWstate (Const Int : integer) : TWindowState;
Function BoolToStr(var bool1 : boolean) : string;
Function StrToBool(var stro1 : string) : boolean;
Function ConvertDosWin(buf : byte) : byte;
Function ConvertWinDos(buf : byte) : byte;
Function GetDraNum(stroka : string) : byte;
function GetVolumeName(RootPath:string):string;
Function GetDirMin1(const pathdir : string) : string;
Function GetFileName2(const FileName : string) : string;
Function GetUnsignedLong(const b1, b2, b3, b4 : byte) : integer;
function UnGetUnsignedLong(const int : integer) : ChetireBaita;
Function GetFloat(const ChB : ChetireBaita) : Extended;
Function UnGetFloat(const Flt : Extended) : ChetireBaita;
Function CheckStrFloat(const St : string) : boolean;
Function CheckCharNum(const Ch : char) : boolean;
Function CheckStrInt(const St : string) : boolean;
Function RoundFloat(const Flt : Extended; Num : integer) : Extended;
Function ObrezatDoNum(const Flt : Extended; Num : integer) : Extended;
Function StrToFloat2(const St : String) : Extended;

implementation

Function GetFilePath(FileName : string) : string;
var
  I : integer;
  PathReady, str1 : string;

begin
  I := 0;
  PathReady := '';
  str1 := '';
  repeat
    repeat
      I := I+1;
      str1 := str1+FileName[I];
    until (FileName[I] = '\') or (FileName[I] = #0);
    If FileName[I] = '\' then PathReady := PathReady+str1;
    //ShowMessage(PathReady);
    str1 := '';
  until FileName[I] = #0;
  result := PathReady;
end;

Function GetFileName(const FileName : string) : string;
var
  I : integer;
  buffer, buffer2 : string;

begin
  I := 0;
  Buffer2 := '';
  repeat
    repeat
      I := I+1;
      buffer := FileName[I];
      if buffer <> '.' then buffer2 := buffer2 + buffer;
    until (buffer = '\') or (buffer = '.');
    if buffer <> '.' then buffer2 := '';
  until buffer = '.';
  result := buffer2;
end;

Function GetFileName2(const FileName : string) : string;
var
  I : integer;
  buffer, buffer2 : string;

begin
  I := 0;
  Buffer2 := '';
  repeat
    repeat
      I := I+1;
      buffer := FileName[I];
      if buffer <> '.' then buffer2 := buffer2 + buffer;
    until (buffer = '\') or (buffer = '.');
    if buffer <> '.' then buffer2 := ''
  until buffer = '.';
  if buffer = '.' then begin
    buffer2 := buffer2+ '.';
    repeat
      I := I+1;
      buffer := FileName[I];
      if buffer <> #0 then buffer2 := buffer2+ buffer;
    until buffer = #0;
  end;
  result := buffer2;
end;

Function GenerateNumName(const Sch : int64; nam : string) : string;

begin
  If Sch > -1 then result := nam+'000000'+intToStr(Sch);
  If Sch > 9 then result := nam+'00000'+intToStr(Sch);
  If Sch > 99 then result := nam+'0000'+intToStr(Sch);
  If Sch > 999 then result := nam+'000'+intToStr(Sch);
  If Sch > 9999 then result := nam+'00'+intToStr(Sch);
  If Sch > 99999 then result := nam+'0'+intToStr(Sch);
end;

Function ByteToIntStr(const buf : byte) : string;
var
  int : integer;

begin
  int := buf;
  result := inttostr(int);
end;

Function Chetnoe(const Int : int64) : boolean;
var
  Rea : real;
  Int2 : int64;

begin
  Int2 := int div 2;
  Rea := int / 2;
  if Int2 = Rea then result := true
  else result := false;
end;

Function FileExists(const FName, Dir : string) : boolean;
var
  st1 : string;
begin
  result := false;
  st1 := FileSearch(FName,Dir);
  If st1 <> '' then result := true;
end;

Function WstateToInt(Const WState : TWindowState) : Integer;
begin
  result := 0;
  If Wstate = WsMaximized then result := 1;
  If Wstate = WsMinimized then result := 2;
  If Wstate = WsNormal then result := 3;
end;

Function IntToWstate (Const Int : integer) : TWindowState;
begin
  result := WsNormal;
  If Int = 1 then result := WsMaximized;
  if int = 2 then result := WsMinimized;
  If int = 3 then result := WsNormal;
end;

Function BoolToStr(var bool1 : boolean) : string;
begin
  if bool1 = true then result := '1'
  else result := '0';
end;

Function StrToBool(var stro1 : string) : boolean;
begin
  if stro1 = '1' then result := true
  else result := false;
end;

Function ConvertDosWin(buf : byte) : byte;
begin
  result := buf;
  If buf = 137 then result := 201;
  If buf = 150 then result := 214;
  If buf = 147 then result := 211;
  If buf = 138 then result := 202;
  If buf = 133 then result := 197;
  If buf = 141 then result := 205;
  If buf = 131 then result := 195;
  If buf = 152 then result := 216;
  If buf = 153 then result := 217;
  If buf = 135 then result := 199;
  If buf = 149 then result := 213;
  If buf = 154 then result := 218;
  If buf = 148 then result := 212;
  If buf = 155 then result := 219;
  If buf = 130 then result := 194;
  If buf = 128 then result := 192;
  If buf = 143 then result := 207;
  If buf = 144 then result := 208;
  If buf = 142 then result := 206;
  If buf = 139 then result := 203;
  If buf = 132 then result := 196;
  If buf = 134 then result := 198;
  If buf = 157 then result := 221;
  If buf = 159 then result := 223;
  If buf = 151 then result := 215;
  If buf = 145 then result := 209;
  If buf = 140 then result := 204;
  If buf = 136 then result := 200;
  If buf = 146 then result := 210;
  If buf = 156 then result := 220;
  If buf = 129 then result := 193;
  If buf = 158 then result := 222;
  If buf = 240 then result := 168;
  If buf = 169 then result := 233;
  If buf = 230 then result := 246;
  If buf = 227 then result := 243;
  If buf = 170 then result := 234;
  If buf = 165 then result := 229;
  If buf = 173 then result := 237;
  If buf = 163 then result := 227;
  If buf = 232 then result := 248;
  If buf = 233 then result := 249;
  If buf = 167 then result := 231;
  If buf = 229 then result := 245;
  If buf = 234 then result := 250;
  If buf = 228 then result := 244;
  If buf = 235 then result := 251;
  If buf = 162 then result := 226;
  If buf = 160 then result := 224;
  If buf = 175 then result := 239;
  If buf = 224 then result := 240;
  If buf = 174 then result := 238;
  If buf = 171 then result := 235;
  If buf = 164 then result := 228;
  If buf = 166 then result := 230;
  If buf = 237 then result := 253;
  If buf = 239 then result := 255;
  If buf = 231 then result := 247;
  If buf = 225 then result := 241;
  If buf = 172 then result := 236;
  If buf = 168 then result := 232;
  If buf = 226 then result := 242;
  If buf = 236 then result := 252;
  If buf = 161 then result := 225;
  If buf = 238 then result := 254;
  If buf = 241 then result := 184;
end;

Function ConvertWinDos(buf : byte) : byte;
begin
  result := buf;
  If buf = 201 then result := 137;
  If buf = 214 then result := 150;
  If buf = 211 then result := 147;
  If buf = 202 then result := 138;
  If buf = 197 then result := 133;
  If buf = 205 then result := 141;
  If buf = 195 then result := 131;
  If buf = 216 then result := 152;
  If buf = 217 then result := 153;
  If buf = 199 then result := 135;
  If buf = 213 then result := 149;
  If buf = 218 then result := 154;
  If buf = 212 then result := 148;
  If buf = 219 then result := 155;
  If buf = 194 then result := 130;
  If buf = 192 then result := 128;
  If buf = 207 then result := 143;
  If buf = 208 then result := 144;
  If buf = 206 then result := 142;
  If buf = 203 then result := 139;
  If buf = 196 then result := 132;
  If buf = 198 then result := 134;
  If buf = 221 then result := 157;
  If buf = 223 then result := 159;
  If buf = 215 then result := 151;
  If buf = 209 then result := 145;
  If buf = 204 then result := 140;
  If buf = 200 then result := 136;
  If buf = 210 then result := 146;
  If buf = 220 then result := 156;
  If buf = 193 then result := 129;
  If buf = 222 then result := 158;
  If buf = 168 then result := 240;
  If buf = 233 then result := 169;
  If buf = 246 then result := 230;
  If buf = 243 then result := 227;
  If buf = 234 then result := 170;
  If buf = 229 then result := 165;
  If buf = 237 then result := 173;
  If buf = 227 then result := 163;
  If buf = 248 then result := 232;
  If buf = 249 then result := 233;
  If buf = 231 then result := 167;
  If buf = 245 then result := 229;
  If buf = 250 then result := 234;
  If buf = 244 then result := 228;
  If buf = 251 then result := 235;
  If buf = 226 then result := 162;
  If buf = 224 then result := 160;
  If buf = 239 then result := 175;
  If buf = 240 then result := 224;
  If buf = 238 then result := 174;
  If buf = 235 then result := 171;
  If buf = 228 then result := 164;
  If buf = 230 then result := 166;
  If buf = 253 then result := 237;
  If buf = 255 then result := 239;
  If buf = 247 then result := 231;
  If buf = 241 then result := 225;
  If buf = 236 then result := 172;
  If buf = 232 then result := 168;
  If buf = 242 then result := 226;
  If buf = 252 then result := 236;
  If buf = 225 then result := 161;
  If buf = 254 then result := 238;
  If buf = 184 then result := 241;
end;

Function GetDraNum(stroka : string) : byte;
begin
  stroka := UpperCase(stroka);
  if stroka[1] = 'A' then result := 1;
  if stroka[1] = 'B' then result := 2;
  if stroka[1] = 'C' then result := 3;
  if stroka[1] = 'D' then result := 4;
  if stroka[1] = 'E' then result := 5;
  if stroka[1] = 'F' then result := 6;
  if stroka[1] = 'G' then result := 7;
  if stroka[1] = 'H' then result := 8;
  if stroka[1] = 'I' then result := 9;
  if stroka[1] = 'J' then result := 10;
  if stroka[1] = 'K' then result := 11;
  if stroka[1] = 'L' then result := 12;
  if stroka[1] = 'M' then result := 13;
  if stroka[1] = 'N' then result := 14;
  if stroka[1] = 'O' then result := 15;
  if stroka[1] = 'P' then result := 16;
  if stroka[1] = 'Q' then result := 17;
  if stroka[1] = 'R' then result := 18;
  if stroka[1] = 'S' then result := 19;
  if stroka[1] = 'T' then result := 20;
  if stroka[1] = 'U' then result := 21;
  if stroka[1] = 'V' then result := 22;
  if stroka[1] = 'W' then result := 23;
  if stroka[1] = 'X' then result := 24;
  if stroka[1] = 'Y' then result := 25;
  if stroka[1] = 'Z' then result := 26;
end;

function GetVolumeName(RootPath:string):string;
var
  VNBuffer:array[0..11] of char;
  MCLength,FSFlags:DWORD;
begin
  Result:='';
  if
GetVolumeInformation(PChar(RootPath),VNBuffer,SizeOf(VNBuffer),nil,MCLength,FSFlags,nil,0) then Result:=string(VNBuffer);
end;

Function GetDirMin1(const pathdir : string) : string;
var
  I : integer;
  str1, str2 : string;
begin
  I := 0;
  str1 := '';
  str2 := '';
  repeat
    str2 := str2+str1;
    repeat
      I := I+1;
      str1 := str1+pathdir[I];
    until pathdir[i] = '\';
  until pathdir[I+1] = #0;
  result := str2;
end;

Constructor TFileInString.Init;
begin
  //.   .
  FirstLoaded := false;
  Siz := 0;
  SetLength(FileString,Siz);
  FileString := '';
end;

procedure TFileInString.Load(const FName : string);
var
  I : int64;
  F1 : file;
  //f2 : file of byte;
  buf : array[1..2048] of char;
  NumRead : integer;
begin
  //   .
  //     .
  //      :).
  If FileExists(GetFileName2(FName),GetFilePath(FName)) then begin
    //      ....
    // 
    Siz := 0;
    AssignFile(F1,FName);
    Reset(F1,1);
    Siz := FileSize(F1);
    // 
    SetLength(FileString,Siz);
    FileString := '';
    // ...
      repeat
      BlockRead(F1,buf,sizeof(buf),numread);
      //  
      if NumRead = SizeOf(Buf) then begin
        //siz := siz+SizeOf(Buf);
        FileString := FileString+buf
      end
      //  
      else if numread <> 0 then begin
        I := 0;
        repeat
          I := I+1;
          FileString := FileString+buf[I];
        until I = numread;
        //siz := siz+numread;
      end;
    until NumRead <> SizeOf(Buf);
    //    ,      .
    CloseFile(F1);
    FirstLoaded := true;
  end
  else begin
    //   ( ),   !
    MessageDLG('!     , ..   .  .',mtError,[mbOk],0);
  end;
end;

procedure TFileInString.Save(const FName : string);
var
  F1 : file;
  F : integer;
  buf : array[1..2048] of char;
  I, J : int64;
begin
  // .
  if FirstLoaded = true then begin
    //   ,  .
    //      .
    AssignFile(F1,FName);
    Rewrite(f1,1);
    J := Siz;
    F:= 0;
    //  .
    repeat
      I := 0;
      Repeat
        //    .
        I := I+1;
        //F -  ""    .
        F := F+1;
        //J -   -       .
        J := J-1;
        buf[I] := FileString[F];
      until (I = SizeOf(Buf)) or (J = 0);
      BlockWrite(F1,Buf,I);
    until J = 0;
    CloseFile(F1);
  end
  else begin
    //  ,   !
    MessageDLG(',          !     ???  ,    :(',mtError,[mbOk],0);
  end;
end;

Procedure TFileInString.MakNewFile;
begin
  //  ""  -     .
  FirstLoaded := true;
  Siz := 0;
  SetLength(FileString,Siz);
  FileString := '';
end;

Procedure TFileInString.AddChar(const ch : char);
begin
  //       .
  FileString := FileString+ch;
  siz := siz+1;
end;

Procedure TFileInString.AddByte(const bt : byte);
begin
  //       ...
  FileString := FileString+char(bt);
  siz := siz+1;
end;

Function GetUnsignedLong(const b1, b2, b3, b4 : byte) : integer;
var
  i1, i2, i3, i4, sum : integer;
begin
  //     4 .
  i1 := b1;
  i2 := b2*256;
  I3 := b3*65536;
  I4 := b4*16777216;
  sum := 0;
  sum := i1+i2+i3+i4;
  result := sum;
end;                                   

function UngetUnsignedLong(const int : integer) : ChetireBaita;

begin
  CopyMemory(@result,@int,4);
end;

Function GetFloat(const ChB : ChetireBaita) : Extended;
var
  Fl : single;
begin
  CopyMemory(@Fl,@ChB,4);
  Result := Fl;
end;

Function UnGetFloat(const Flt : Extended) : ChetireBaita;
var
  Fl : Single;
begin
  Fl := Flt;
  CopyMemory(@result,@Fl,4);
end;

Function CheckCharNum(const Ch : char) : boolean;
begin
  result := false;
  if Ch = '0' then result := true;
  if Ch = '1' then result := true;
  if Ch = '2' then result := true;
  if Ch = '3' then result := true;
  if Ch = '4' then result := true;
  if Ch = '5' then result := true;
  if Ch = '6' then result := true;
  if Ch = '7' then result := true;
  if Ch = '8' then result := true;
  if Ch = '9' then result := true;
end;

Function CheckStrFloat(const St : string) : boolean;
var
  zapatih, I : integer;
  ch : char;
begin
  If (st <> '') and (st <> 'NAN') and (st<>'-') then begin
    result := true;
    zapatih := 1;
    I := 0;
    If St[I+1] = '-' then I := I+1;
    repeat
      I := I+1;
      Ch := St[I];
      If ch = ',' then zapatih := zapatih-1
      else if ch <> #0 then if CheckCharNum(Ch) = false then result := false;
    until Ch = #0;
    if zapatih < 0 then result := false;
  end
  else begin
    If St = 'NAN' then result := true
    else Result := false;
  end;
end;

Function CheckStrInt(const St : string) : boolean;
var
  ch : char;
  I : integer;
begin
  If (st <> '') and (st<>'-') then begin
    result := true;
    I := 0;
    If St[I+1] = '-' then I := I+1;
    repeat
      I := I+1;
      Ch := St[I];
      if ch <> #0 then if CheckCharNum(Ch) = false then result := false;
    until Ch = #0;
  end  
  else result := false;
end;

Function RoundFloat(const Flt : Extended; Num : integer) : Extended;
var
  Fl1, Fl2, Fl3 : Single;
  Ch1, Ch2, Ch3, Ch4 : string;
  I, Dop : integer;
  Minused : boolean;
begin
  If FloatToStr(Flt) <> 'NAN' then begin
  //   ()  Num   .
  Minused := false;
  Fl3 := Flt;
  If Flt < 0 then begin
    // . ...
    Fl3 := Flt*-1;
    Minused := true;
  end;
  Fl1 := int(Fl3);     // 
  Fl2 := Frac(Fl3);    // 
  Ch1 := FloatToStr(Fl1);
  Ch2 := FloatToStr(Fl2);
  //        Num ...
  if Fl2 <> 0 then begin
    Ch3 := '';
    I := 2;
    repeat
      I := I+1;
      if Ch2[I] <> #0 then Ch3 := Ch3+Ch2[I];
    until (ch2[I] = #0) or (I = Num+2);
    if ch2[I] = #0 then I := I-1;
    //  ....
    if I = Num+2 then begin
      I := Num;
      if StrToInt(Ch3[I]) > 4 then begin
        //   ...
        Ch3[I] := IntToStr(0)[1];
        Dop := 1;
        repeat
          I := I-1;
          if ch3[I] = IntToStr(9)[1] then begin
            ch3[I] := IntToStr(0)[1];
          end
          else begin
            Ch3[I] := IntToStr(StrToInt(Ch3[I])+Dop)[1];
            Dop := 0;
          end;
        until I = 1;
      end;
    end;
    For I := 1 to 15 do begin
      //  15   .
      if I > Num then Ch3 := Ch3+'0';
    end;
    Ch4 := Ch1+','+Ch3;
  end
  else begin
    Ch3 := ',';
    For I := 1 to 15 do begin
      Ch3 := Ch3+'0';
    end;
    Ch4 := Ch1+Ch3;
  end;
  Result := StrToFloat(Ch4);
  If Minused then Result := Result*-1;
  end
  else result := Flt;
end;

Function ObrezatDoNum(const Flt : Extended; Num : integer) : Extended;
var
  St1, St2 : String;
  I : integer;
begin
  St1 := FloatToStr(Flt);
  St2 := '';
  For I := 1 to Num do begin
    St2 := St2+St1[I];
  end;
  Result := StrToFloat(St2);
end;

Function StrToFloat2(const St : String) : Extended;
var
  ChB : ChetireBaita;
begin
  ChB[1] := 255;
  ChB[2] := 255;
  ChB[3] := 255;
  ChB[4] := 255;
  If St <> 'NAN' then result := StrToFloat(St)
  else Result := GetFloat(ChB);
end;

end.
